import { Link } from 'react-router-dom'
import { PenTool, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <PenTool className="footer-logo-icon" size={24} strokeWidth={1.5} />
              <h2 className="footer-logo-text">Atelier</h2>
            </div>
            <p className="footer-description">
              Изучайте искусство рисования в атмосфере элегантности и профессионализма. 
              Наши преподаватели помогут вам раскрыть творческий потенциал через классические техники.
            </p>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Навигация</h3>
            <ul className="footer-links">
              <li><Link to="/">Мои занятия</Link></li>
              <li><Link to="/enroll">Записаться</Link></li>
              <li><a href="#">Галерея</a></li>
              <li><a href="#">О студии</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={14} strokeWidth={1.5} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={14} strokeWidth={1.5} />
                <a href="mailto:info@atelier.ru">info@atelier.ru</a>
              </li>
              <li>
                <MapPin size={14} strokeWidth={1.5} />
                <span>Москва, ул. Искусств, 8</span>
              </li>
              <li>
                <Clock size={14} strokeWidth={1.5} />
                <span>Пн-Сб: 11:00 - 19:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 Atelier. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

